% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimNonNormalDist.R
\name{SimNonNormalDist}
\alias{SimNonNormalDist}
\title{SimNonNormalDist function}
\usage{
SimNonNormalDist(nInv, noisePer)
}
\arguments{
\item{nInv}{is a number of samples the function will generate for each category.}

\item{noisePer}{is ratio of uniform distribution within a mixture distribution.
It is considered as a uniform noise that make an approach to hardly distinguish whether one distribution dominates another.}
}
\value{
This function returns a list of samples \code{Values} and their category \code{Group} generated by a mixture distribution.

\item{Values}{ A vector of samples generated by a mixture distribution. }
\item{Group}{ A list of categories associated with \code{Values}. }
\item{V1,...,V5}{Lists of sample vectors separated by categories.}
}
\description{
SimNonNormalDist is a support function for generating samples from mixture distribution.
There are five categories. Each categories has \code{nInv} samples.
Categories C1,C2,C3, and C4 are dominated by C5 but none of them dominate each other.
}
\details{
The main purpose of this function is to generate samples that contains domination relation among categories.
}
\examples{
# Generate simulation data with 100 samples per categories with 10\% of uniform noise

simData<-SimNonNormalDist(nInv=100,noisePer=0.1)


}
