% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimmerplot.R
\name{edc_swimmerplot}
\alias{edc_swimmerplot}
\title{Swimmer plot of all dates columns}
\usage{
edc_swimmerplot(
  .lookup = edc_lookup(),
  ...,
  id = get_subjid_cols(),
  group = NULL,
  origin = NULL,
  id_lim = NULL,
  exclude = NULL,
  time_unit = c("days", "weeks", "months", "years"),
  aes_color = c("variable", "label"),
  plotly = getOption("edc_plotly", FALSE)
)
}
\arguments{
\item{.lookup}{the lookup table, default to \code{edc_lookup()}}

\item{...}{not used}

\item{id}{the patient identifier. Will be coerced as numeric.}

\item{group}{a grouping variable, given as "dataset$column"}

\item{origin}{a variable to consider as time 0, given as "dataset$column"}

\item{id_lim}{a numeric vector of length 2 providing the minimum and maximum \code{id} to subset on.}

\item{exclude}{a character vector of variables to exclude, in the form \code{dataset$column}. Can be a regex, but \code{$} symbols don't count. Case-insensitive.}

\item{time_unit}{if \code{origin!=NULL}, the unit to measure time. One of \code{c("days", "weeks", "months", "years")}.}

\item{aes_color}{either \code{variable} ("\{dataset\} - \{column\}") or \code{label} (the column label)}

\item{plotly}{whether to use \code{{plotly}} to get an interactive plot}
}
\value{
either a \code{plotly} or a \code{ggplot}
}
\description{
Join all tables from \code{.lookup$dataset} on \code{id}
}
\examples{
#tm = read_trialmaster("filename.zip", pw="xx")
tm = edc_example_plot()
load_list(tm)
p = edc_swimmerplot(.lookup, id_lim=c(5,45))
p2 = edc_swimmerplot(.lookup, origin="db0$date_naissance", time_unit="weeks", 
                     exclude=c("DB1$DATE2", "db3$.*"))
p3 = edc_swimmerplot(.lookup, group="db0$group", aes_color="label")
\dontrun{
#save the plotly plot as HTML to share it
save_plotly(p, "edc_swimmerplot.html")
}
}
