% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebase_rho.R
\name{ebase_rho}
\alias{ebase_rho}
\title{Seawater density calculation}
\usage{
ebase_rho(temp, salt, P)
}
\arguments{
\item{temp}{numeric for temperature (C)}

\item{salt}{numeric for salinity (PSU)}

\item{P}{numeric for pressure above atmospheric (dbar)}
}
\value{
Rho (kg/m^3)
}
\description{
Seawater density calculation
}
\details{
Density of seawater is calculated according to the internationally accepted (UNESCO) equations. The standard error of the equation is 3.6 x 10-3 kg/m-3.
}
\examples{
temp <- c(10, 20, 30)
salt <- c(30, 35, 40)
ebase_rho(temp = temp, salt = salt, P = 0)
}
\references{
Millero, F.J., Poisson, A., 1981. International one-atmosphere equation of state of seawater. Deep Sea Research 28, 625-629. https://doi.org/10.1016/0198-0149(81)90122-9
}
