% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortUtilities.R
\name{computeCohortAttrition}
\alias{computeCohortAttrition}
\title{Add a line in the attrition table. If the table does not exist it is created}
\usage{
computeCohortAttrition(
  x,
  cdm,
  attrition = NULL,
  reason = "Qualifying initial records"
)
}
\arguments{
\item{x}{A table in the cdm with at lest: 'cohort_definition_id' and
subject_id'}

\item{cdm}{A cdm reference created using CDMConnector}

\item{attrition}{An attrition table. If NULL a new attrition table is created.}

\item{reason}{A character with the name of the reason.}
}
\value{
Reference to a table with the cohort attrition
}
\description{
Add a line in the attrition table. If the table does not exist it is created
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)
library(PatientProfiles)

cdm <- mockDrugUtilisation()

cdm$new_cohort <- cdm$observation_period \%>\%
  mutate(cohort_definition_id = 1) \%>\%
  select(
    cohort_definition_id, subject_id = person_id,
    cohort_start_date = observation_period_start_date,
    cohort_end_date = observation_period_end_date
  ) \%>\%
  compute()

attrition <- computeCohortAttrition(cdm$new_cohort, cdm)

cdm$new_cohort <- cdm$new_cohort \%>\%
  addSex(cdm = cdm) \%>\%
  filter(sex == "Female") \%>\%
  select(-"sex") \%>\%
  compute()

attrition <- computeCohortAttrition(
  cdm$new_cohort, cdm, attrition, "Exclude males"
)

print(attrition)
}

}
