% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{phosphosite_data}
\alias{phosphosite_data}
\title{Phosphosite data}
\format{
\describe{
  \item{groupA}{ER+ data; data.frame: first three columns contain phosphosite and protein identifiers
                site_id, ref_seq and gene_name;
                other columns are samples containing the quantified phosphosite data per phosphosite}
  \item{groupB}{ER- data; data.frame: first three columns contain phosphosite and protein identifiers
                site_id, ref_seq and gene_name;
                other columns are samples containing the quantified phosphosite data per phosphosite}
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
 Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
phosphosite_data
}
\description{
Phosphosite analysis of breast cancer patients data from Krug et al. (2020) (data from the Clinical
Proteomic Tumor Analysis Consortium (CPTAC)). The data is stratified by estrogen receptor (ER)
expression status (`groupA` = ER+, `groupB` = ER-). The data was reduced to 50 genes.
For each group a data frame is given containing the raw data with the phosphosites as rows and the
samples as columns. The first three columns contain the phosphosite and protein identifiers
(site_id, ref_seq and gene_name).
}
\keyword{datasets}
