% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BINCOMP.R
\name{p_BINCOMP}
\alias{p_BINCOMP}
\alias{E_BINCOMP}
\alias{V_BINCOMP}
\alias{VaR_BINCOMP}
\alias{TVaR_BINCOMP}
\title{Compound Binomial Distribution}
\usage{
p_BINCOMP(
  x,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

E_BINCOMP(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

V_BINCOMP(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

VaR_BINCOMP(
  kap,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

TVaR_BINCOMP(
  kap,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  vark,
  k0,
  distr_severity = "Gamma"
)
}
\arguments{
\item{x}{quantile.}

\item{size}{Number of trials (0 or more).}

\item{prob}{Probability of success in each trial.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive integer.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{distr_severity}{Choice of severity distribution.
\itemize{
 \item{"gamma"} (default)
 \item{"lognormal"} only for the expected value and variance.
}}

\item{kap}{probability.}

\item{vark}{Value-at-Risk (VaR) calculated at the given probability kap.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{p_BINCOMP}}}{ gives the cumulative density function.}
 \item{\code{\link{E_BINCOMP}}}{ gives the expected value.}
 \item{\code{\link{V_BINCOMP}}}{ gives the variance.}
 \item{\code{\link{TVaR_BINCOMP}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_BINCOMP}}}{ gives the Value-at-Risk.}
 }
 Returned values are approximations for the cumulative density function,
 TVaR, and VaR.
}
\description{
Computes various risk measures (mean, variance, Value-at-Risk (VaR),
  and Tail Value-at-Risk (TVaR)) for the compound Binomial distribution.
}
\details{
The compound Binomial Distribution has density ....
}
\examples{
p_BINCOMP(x = 2, size = 1, prob = 0.2, shape = log(1000) - 0.405,
          rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

E_BINCOMP(size = 1, prob = 0.2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

V_BINCOMP(size = 1, prob = 0.2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

VaR_BINCOMP(kap = 0.9, size = 1, prob = 0.2, shape = log(1000) - 0.405,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

vark_calc <- VaR_BINCOMP(kap = 0.9, size = 1, prob = 0.2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")
TVaR_BINCOMP(kap = 0.9, size = 1, prob = 0.2, shape = 0.59, rate = 0.9^2,
            vark = vark_calc, k0 = 1E2, distr_severity = "Gamma")

}
