% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux_fun.R
\name{match.pvals}
\alias{match.pvals}
\title{Matching raw p-values with supports}
\usage{
match.pvals(pCDFlist, raw.pvalues)
}
\arguments{
\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}

\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbour in the CDFs supports.}
}
\value{
A vector where each raw p-value has been
replaced by its nearest neighbour.
}
\description{
Constructs the observed p-values from the raw observed p-values, 
by rounding them to their nearest neighbour matching
with the supports of their respective
CDFs (as in function \code{\link[discreteMTP]{p.discrete.adjust}} 
of package \code{\link[discreteMTP]{discreteMTP}}).
The end user should not use it.
}
\details{
Well computed raw p-values should already 
belong to their respective CDF support.
So this function is called at the beginning
of \code{\link{DBH}}, \code{\link{ADBH}},
and \code{\link{DBR}}, just in case
raw p-values are biased.

For each raw p-value that needs to be rounded,
a warning is issued.

This version: 2017-08-16.
}
\examples{
toyList <- list(c(0.3,0.7,1),c(0.1,0.65,1))
toyRaw1 <- c(0.3,0.65)
match.pvals(toyList,toyRaw1)
toyRaw2 <- c(0.31,0.6)
match.pvals(toyList,toyRaw2)

}
\seealso{
\code{\link{discrete.BH}}, \code{\link{DBR}}
}
