% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bridging.R
\name{get_bridging}
\alias{get_bridging}
\title{Get bridging scores}
\usage{
get_bridging(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame with bridging scores for each of the nodes.
}
\description{
Get the bridging scores (based on Valente's Bridging vertex measure) for all
nodes in a graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 12,
    set_seed = 23)

# Get the bridging scores for nodes
# in the graph
graph \%>\% get_bridging()

# Add the bridging scores to
# the graph as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_bridging(.))

# Display the graph's node data frame
graph \%>\% get_node_df()

}
