% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_automorphisms.R
\name{count_automorphisms}
\alias{count_automorphisms}
\title{Get the number of automorphisms in the graph}
\usage{
count_automorphisms(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value representing the
number of automorphisms the graph contains.
}
\description{
Get the number of automorphisms the
graph contains. An automorphism of a graph is a
form of symmetry in which the graph is mapped onto
itself while preserving edge-node connectivity.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Get a count of automorphisms
count_automorphisms(graph)
#> [1] 10

# Create a full graph and then
# count the automorphisms
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  count_automorphisms()
#> [1] 3628800
}
