% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_attrs.R
\name{get_node_attrs}
\alias{get_node_attrs}
\title{Get node attribute values}
\usage{
get_node_attrs(graph, node_attr, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr}{the name of the attribute for which
to get values.}

\item{nodes}{an optional vector of node IDs for
filtering list of nodes present in the graph or
node data frame.}
}
\value{
a named vector of node attribute values for
the attribute given by \code{node_attr} by node ID.
}
\description{
From a graph object of class
\code{dgr_graph}, get node attribute values for
one or more nodes.
}
\examples{
# Create a random graph and
# incorporate the node attribute
# called `value`
graph <-
  create_random_graph(
    n = 4, m = 4,
    set_seed = 23)

# Get all of the values from
# the `value` node attribute
# as a named vector
graph \%>\%
  get_node_attrs(
    node_attr = value)
#>   1   2   3   4
#> 6.0 2.5 3.5 7.5

# To only return node attribute
# values for specified nodes,
# use the `nodes` argument
graph \%>\%
  get_node_attrs(
    node_attr = value,
    nodes = c(1, 3))
#>   1   3
#> 6.0 3.5
}
