% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_present.R
\name{node_present}
\alias{node_present}
\title{Determine whether a specified node is present in an
existing graph object}
\usage{
node_present(graph, node)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{node}{a value that may or may not match a node
ID in the graph.}
}
\value{
a logical value.
}
\description{
From a graph object of class
\code{dgr_graph}, determine whether a specified node
is present.
}
\examples{
# Create a node data frame
nodes <-
  create_nodes(
    nodes = LETTERS,
    label = TRUE,
    type = "letter")

# Create an edge data frame
edges <-
  create_edges(
    from = sample(LETTERS, replace = TRUE),
    to = sample(LETTERS, replace = TRUE),
    rel = "letter_to_letter")

# Create a graph
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Verify that node with ID `a` is not in graph
node_present(graph, "a")
#> FALSE

# Is node with ID `A` in the graph?
node_present(graph, "A")
#> TRUE

# Are all node ID values from the LETTERS vector
# in the graph?
all(sapply(LETTERS,
      function(x) node_present(graph, x)))
#> TRUE
}

