/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class TextAreaWidget
extends JPanel
implements DeducerWidget {
    private JScrollPane scroller;
    private JTextArea text;
    private String title;
    private String initialModel;
    private String lastModel;

    public TextAreaWidget(String string) {
        this.title = string;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayout(borderLayout);
            this.setPreferredSize(new Dimension(233, 61));
            if (this.title != null) {
                this.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            this.scroller = new JScrollPane();
            this.add((Component)this.scroller, "Center");
            this.text = new JTextArea();
            this.scroller.setViewportView(this.text);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JTextArea getTextArea() {
        return this.text;
    }

    public String getText() {
        return (String)this.getModel();
    }

    public void setText(String string) {
        this.setModel(string);
    }

    public Object getModel() {
        return this.text.getText();
    }

    public String getRModel() {
        return "\"" + Deducer.addSlashes((String)this.getModel()) + "\"";
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        this.initialModel = (String)object;
        if (this.lastModel == null) {
            this.lastModel = (String)object;
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = (String)object;
    }

    public void setModel(Object object) {
        if (object == null) {
            object = "";
        }
        this.text.setText((String)object);
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

