% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.r
\name{fit.dl}
\alias{fit.dl}
\title{Perform all the steps necessary to fit the model:
\enumerate{
  \item prepare the data
  \item find suitable initialisations
  \item fit the model using the specified method (sampling or variational Bayes)
  \item process the posterior
}}
\usage{
fit.dl(dl, method = "sample", ...)
}
\arguments{
\item{dl}{de.lorean object}

\item{method}{Fitting method:
\itemize{
  \item 'sample': Use a Stan sampler.
    See \code{\link{fit.model.sample}}.
  \item 'vb': Use Stan ADVI variational Bayes algorithm.
    See \code{\link{fit.model.vb}}.
}}

\item{...}{Extra arguments for fitting method}
}
\description{
Perform all the steps necessary to fit the model:
\enumerate{
  \item prepare the data
  \item find suitable initialisations
  \item fit the model using the specified method (sampling or variational Bayes)
  \item process the posterior
}
}
