% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{lowLevelQuerySql.ffdf}
\alias{lowLevelQuerySql.ffdf}
\title{Low level function for retrieving data to an ffdf object}
\usage{
lowLevelQuerySql.ffdf(connection, query = "", datesAsString = FALSE)
}
\arguments{
\item{connection}{The connection to the database server.}

\item{query}{The SQL statement to retrieve the data}

\item{datesAsString}{Should dates be imported as character vectors, our should they be converted
to R's date format?}
}
\value{
A ffdf object containing the data. If there are 0 rows, a regular data frame is returned instead
(ffdf cannot have 0 rows)
}
\description{
This is the equivalent of the \code{\link{querySql.ffdf}} function, except no error report is
written when an error occurs.
}
\details{
Retrieves data from the database server and stores it in an ffdf object. This allows very large
data sets to be retrieved without running out of memory. Null values in the database are converted
to NA values in R.
}
