% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbRemoveTable,DatabaseConnectorConnection,character-method}
\alias{dbRemoveTable,DatabaseConnectorConnection,character-method}
\title{Remove a table from the database}
\usage{
\S4method{dbRemoveTable}{DatabaseConnectorConnection,character}(conn, name,
  database = NULL, schema = NULL, oracleTempSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{oracleTempSchema}{Specifically for Oracle, a schema with write priviliges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbRemoveTable()} returns \code{TRUE}, invisibly.
If the table does not exist, an error is raised.
An attempt to remove a view with this function may result in an error.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
}
\description{
Remove a remote table (e.g., created by \code{\link[=dbWriteTable]{dbWriteTable()}})
from the database.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbRemoveTable")}
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
