% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/databel_class.R
\docType{class}
\name{databel-class}
\alias{[,databel-method}
\alias{[<-,databel-method}
\alias{backingfilename}
\alias{backingfilename,databel-method}
\alias{cachesizeMb}
\alias{cachesizeMb,databel-method}
\alias{cachesizeMb<-}
\alias{cachesizeMb<-,databel-method}
\alias{connect}
\alias{connect,databel-method}
\alias{databel-class}
\alias{dim,databel-method}
\alias{dimnames,databel-method}
\alias{dimnames<-,databel-method}
\alias{disconnect}
\alias{disconnect,databel-method}
\alias{get_dimnames}
\alias{get_dimnames,databel-method}
\alias{length,databel-method}
\alias{save_as}
\alias{save_as,databel-method}
\alias{setReadOnly<-}
\alias{setReadOnly<-,databel-method}
\alias{set_dimnames<-}
\alias{set_dimnames<-,databel-method}
\alias{show,databel-method}
\title{DatABEL class}
\usage{
\S4method{show}{databel}(object)

\S4method{dim}{databel}(x)

\S4method{length}{databel}(x)

\S4method{dimnames}{databel}(x)

\S4method{dimnames}{databel}(x) <- value

\S4method{[}{databel}(x, i, j, drop)

\S4method{[}{databel}(x, i, j) <- value

get_dimnames(object)

set_dimnames(x) <- value

backingfilename(object)

cachesizeMb(object)

cachesizeMb(x) <- value

save_as(x, rows, cols, file, cachesizeMb = 64, readonly = TRUE)

connect(object, readonly = TRUE)

disconnect(object)

setReadOnly(x) <- value
}
\arguments{
\item{object}{A DatABEL object}

\item{x}{A DatABEL object}

\item{value}{Values to be replaced/inserted}

\item{i}{Row index}

\item{j}{Column index}

\item{drop}{Boolean (FALSE by default); UNUSED}

\item{rows}{Index for the rows}

\item{cols}{Index for the columns}

\item{file}{Filename to save to}

\item{cachesizeMb}{Amount (in MB) of RAM to use for caching DatABEL
data.}

\item{readonly}{Boolean that specifies whether the file is to be
used in read-only mode or not}
}
\description{
DatABEL stores matrix-shape data in such a way that it can be
retrieved fast.
}
\section{Slots}{

\describe{
\item{\code{usedRowIndex}}{(\code{"integer"})}

\item{\code{usedColIndex}}{(\code{"integer"})}

\item{\code{uninames}}{(\code{"list"})}

\item{\code{backingfilename}}{Name of the (stem of the) file that contains
the data stored in DatABEL format (\code{"character"})}

\item{\code{cachesizeMb}}{Amount (in MB) of RAM to use for caching DatABEL
data. (\code{"integer"})}

\item{\code{data}}{(\code{"externalptr"})}
}}
\note{
Will extend description here
}
\author{
Yurii Aulchenko
}

