% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idcharacteristics_ode.R
\name{simulate_idcharacteristics_ode}
\alias{simulate_idcharacteristics_ode}
\title{Simulation of an infectious disease transmission model with multiple compartments}
\usage{
simulate_idcharacteristics_ode(
  S = 1000,
  P = 1,
  bP = 0,
  bA = 0,
  bI = 0.001,
  gP = 0.5,
  gA = 0.5,
  gI = 0.5,
  f = 0,
  d = 0,
  tmax = 300
)
}
\arguments{
\item{S}{: initial number of susceptible hosts : numeric}

\item{P}{: initial number of infected, pre-symptomatic hosts : numeric}

\item{bP}{: level/rate of infectiousness for hosts in the P compartment : numeric}

\item{bA}{: level/rate of infectiousness for hosts in the A compartment : numeric}

\item{bI}{: level/rate of infectiousness for hosts in the I compartment : numeric}

\item{gP}{: rate at which a person leaves the P compartment, which : numeric}

\item{gA}{: rate at which a person leaves the A compartment : numeric}

\item{gI}{: rate at which a person leaves the A compartment : numeric}

\item{f}{: fraction of pre-symptomatic individuals that have an asymptomatic infection : numeric}

\item{d}{: fraction of symptomatic infected hosts that die due to disease : numeric}

\item{tmax}{: maximum simulation time : numeric}
}
\value{
The function returns the output from the odesolver as a matrix,
with one column per compartment/variable. The first column is time.
}
\description{
Simulation of a compartmental model with several different compartments:
Susceptibles (S), Infected and Pre-symptomatic (P),
Infected and Asymptomatic (A), Infected and Symptomatic (I),
Recovered and Immune (R) and Dead (D)
}
\details{
A compartmental ID model with several states/compartments
is simulated as a set of ordinary differential equations. The states
are:
**S**: Susceptible, uninfected individuals
**P**: Presymptomatic individuals who are infected and possibly infectious
**A**: Asymptomatic individuals who are infected and possibly infectious
**I**: Sympomatic infected individuals, most likely infectious
**R**: Removed / recovered individuals, no longer infectious or susceptible
**D**: Individuals who have died from the disease
The model app contains detailed information on the processes, but briefly,
susceptible (S) individuals can become infected by presymptomatic (P), asymptomatic (A),
or infected (I) hosts. All infected individuals enter the presymptomatic stage first,
from which they can become symptomatic or asymptomatic. Asymptomatic hosts recover
within some specified duration of time, while infected hosts either recover or die,
thus entering either R or D. Recovered individuals are immune to reinfection.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have negative values for parameters),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_idcharacteristics_ode()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_idcharacteristics_ode(S = 2000, P = 10, tmax = 100, f = 0.1, d = 0.2)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\author{
Andreas Handel
}
