% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeighbourhoodMatrixNetwork.R
\name{NeighbourhoodMatrixNetwork}
\alias{NeighbourhoodMatrixNetwork}
\title{Creates the neighbourhood structure of a linear network}
\usage{
NeighbourhoodMatrixNetwork(network)
}
\arguments{
\item{network}{- A \code{linnet} object representing a linear network structure}
}
\value{
Returns a \code{listw} object in \code{"W"} style
}
\description{
Given a linear network structure, this function creates the neighbourhood matrix ("queen" criterion) associated to it. Two segments of the network are neighbours if they share a vertex
}
\examples{
library(DRHotNet)
library(spatstat.core)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
library(raster)
library(maptools)
chicago_neighbourhood <- NeighbourhoodMatrixNetwork(chicago$domain)
class(chicago_neighbourhood)
chicago_neighbourhood$neighbours[[1]]
}
