% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPP_C.R
\docType{class}
\name{dppMCMC_C}
\alias{dppMCMC_C}
\title{A Reference Class that provides DPP functionality}
\description{
This MCMC takes data numeric vector (Y) and assigns the elements of Y
to a (potentially infinite) number of normal distributions. The individual normal distributions from a mixture of normals can be inferred.
}
\details{
Class dppMCMC_C
Class \code{dppMCMC_C} A Reference Class that provides DPP functionality
}
\section{Fields}{

\describe{
\item{\code{dpp_mcmc_object}}{a DPPmcmc object}
}}

\section{Methods}{

\describe{
\item{\code{getNumCategoryProbabilities(burnin_cutoff = 0.25)}}{returns the probabilities vector for inferred number of categories}

\item{\code{getNumCategoryTrace(burnin_cutoff = 0.25)}}{returns the trace vector for the inferred number of categories in the data}

\item{\code{initialize(data, output, model, num_auxiliary_tables = 4,
  expected_k = 2, power = 1, verbose = TRUE)}}{the class constructor, initializes DPPmcmc object with data and parameters}

\item{\code{run(generations, sample_freq = generations/1000, log_file, allocation_file,
  param_file, append = TRUE, random = FALSE, auto_stop = FALSE,
  min_ess = 500, max_gen = 1e+05)}}{starts the MCMC run}
}}

\examples{
normal.model<-new(NormalModel,
                 mean_prior_mean=0.5,
                 mean_prior_sd=0.1,
                 sd_prior_shape=3,
                 sd_prior_rate=20,
                 estimate_concentration_parameter=TRUE,
                 concentration_parameter_alpha=10,
                 proposal_disturbance_sd=0.1)

#simulating three normal distributions
y <- c(rnorm(100,mean=0.2,sd=0.05), rnorm(100,0.7,0.05), rnorm(100,1.3,0.1))
hist(y,breaks=30)

#setwd("~/yourwd") #mcmc log files will be saved here
my_dpp_analysis <- dppMCMC_C(data=y,
                             output = "output_prefix_",
                             model=normal.model,
                             num_auxiliary_tables=4,
                             expected_k=1.5,
                             power=1)
#running the mcmc  , generations will be ignored because auto_stop=true
\dontrun{
my_dpp_analysis$run(generations=1000,auto_stop=TRUE,max_gen = 10000,min_ess = 500)

#we get rid of the first 25\% of the output (burn-in)
hist(my_dpp_analysis$getNumCategoryTrace(0.25))

my_dpp_analysis$getNumCategoryProbabilities(0.25)
}

}
