% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{CalcMPDynamics}
\alias{CalcMPDynamics}
\title{Calculate population dynamics from MP recommendation}
\usage{
CalcMPDynamics(MPRecs, y, nyears, proyears, nsim, Biomass_P, VBiomass_P,
  LastEi, LastSpatial, LastAllocat, LastCatch, TACused, maxF, LR5_P, LFR_P,
  Rmaxlen_P, retL_P, retA_P, L5_P, LFS_P, Vmaxlen_P, SLarray_P, V_P,
  Fdisc_P, DR_P, M_ageArray, FM_P, FM_Pret, Z_P, CB_P, CB_Pret, TAC_f, E_f,
  SizeLim_f, FinF, Spat_targ, CAL_binsmid, Linf, Len_age, maxage, nareas,
  Asize, nCALbins, qs, qvar, qinc, checks = FALSE)
}
\arguments{
\item{MPRecs}{A named list of MP recommendations. The names are the same as \code{slotNames('Rec')}, except
for \code{Misc}. Each element in the list is a matrix. With the expection of \code{Spatial}, all elements in list
have \code{nrow=1} and \code{ncol=nsim}. \code{Spatial} has \code{nrow=nareas}. Matrices can be empty matrix, populated with all NAs
(both mean no change in management with respect to this element (e.g. \code{Effort})), or populated with a recommendation.
MPs must either return a recommendation or no recommendation for every simulation for a particular slot (i.e. cannot have some NA and some values).}

\item{y}{The projection year}

\item{nyears}{The number of historical years}

\item{proyears}{The number of projection years}

\item{nsim}{The number of simulations}

\item{Biomass_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total biomass in the projection years}

\item{VBiomass_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with vulnerable biomass in the projection years}

\item{LastEi}{A vector of length \code{nsim} with the most recent effort modifier (fraction of historical effort)}

\item{LastSpatial}{A matrix of \code{nrow=nareas} and \code{ncol=nsim} with the most recent spatial management arrangements}

\item{LastAllocat}{A vector of length \code{nsim} with the most recent allocation}

\item{LastCatch}{A vector of length \code{nsim} with the most recent catch}

\item{TACused}{A vector of length \code{nsim} with the most recent TAC}

\item{maxF}{A numeric value with maximum allowed F. From \code{OM@maxF}}

\item{LR5_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at 5 percent retention.}

\item{LFR_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at full retention.}

\item{Rmaxlen_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the retention at maximum length.}

\item{retL_P}{An array with dimensions \code{nsim}, \code{nCALbins} and \code{nyears+proyears} with retention at length}

\item{retA_P}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with retention at age}

\item{L5_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at 5 percent selectivity}

\item{LFS_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at full selectivity}

\item{Vmaxlen_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the selectivity at maximum length.}

\item{SLarray_P}{An array with dimensions \code{nsim}, \code{nCALbins} and \code{nyears+proyears} with selectivity at length}

\item{V_P}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with selectivity at age}

\item{Fdisc_P}{vector of length \code{nsim} with discard mortality. From \code{OM@Fdisc} but can be updated by MP (\code{Rec@Fdisc})}

\item{DR_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the fraction discarded.}

\item{M_ageArray}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with natural mortality at age}

\item{FM_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total fishing mortality}

\item{FM_Pret}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with fishing mortality of the retained fish}

\item{Z_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total mortality}

\item{CB_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total catch}

\item{CB_Pret}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with retained catch}

\item{TAC_f}{A matrix with \code{nsim} rows and \code{proyears} columns with the TAC implementation error}

\item{E_f}{A matrix with \code{nsim} rows and \code{proyears} columns with the effort implementation error}

\item{SizeLim_f}{A matrix with \code{nsim} rows and \code{proyears} columns with the size limit implementation error}

\item{FinF}{A numeric vector of length \code{nsim} with fishing mortality in the last historical year}

\item{Spat_targ}{A numeric vector of length \code{nsim} with spatial targeting}

\item{CAL_binsmid}{A numeric vector of length \code{nCALbins} with mid-points of the CAL bins}

\item{Linf}{A numeric vector of length \code{nsim} with Linf (from \code{Stock@Linf})}

\item{Len_age}{An array with dimensions \code{nsim}, \code{maxage}, and \code{nyears+proyears} with length-at-age}

\item{maxage}{A numeric value with maximum age from \code{Stock@maxage}}

\item{nareas}{A numeric value with number of areas}

\item{Asize}{A matrix with \code{nsim} rows and \code{nareas} columns with the relative size of each area}

\item{nCALbins}{The number of CAL bins. Should be the same as \code{length(CAL_binsmid)}}

\item{qs}{A numeric vector of length \code{nsim} with catchability coefficient}

\item{qvar}{A matrix with \code{nsim} rows and \code{proyears} columns with catchability variability}

\item{qinc}{A numeric vector of length \code{nsim} with average annual change in catchability}

\item{checks}{Logical. Run internal checks? Currently not used.}
}
\value{
A named list with updated population dynamics
}
\description{
An internal function to calculate the population dynamics for the next time
step based on the recent MP recommendation
}
\author{
A. Hordyk
}
\keyword{internal}
