% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAVGMMI.R
\name{DAVGMMI}
\alias{DAVGMMI}
\title{Impute Missing Values in Response Variable Y Using Distributed AVGMMI Method (With Grouping)}
\usage{
DAVGMMI(data, R, M)
}
\arguments{
\item{data}{A data frame or matrix where the first column is the response variable Y (may contain NA),
and remaining columns are covariates X.}

\item{R}{Number of simulations for stable Beta estimation.}

\item{M}{Number of multiple imputations.}
}
\value{
A list containing:
  \item{Yhat}{The vector of Y with missing values imputed.}
  \item{betahat}{Final averaged regression coefficient estimates used for imputation.}
}
\description{
This function implements the Distributed Averaged Generalized Method of Moments Imputation (DAVGMMI)
to fill in missing values in the response variable Y based on observed covariates X.
Assumes a single group structure and does not require group size input (`n`).
}
\examples{
set.seed(123)
data <- data.frame(
  y = c(rnorm(50), rep(NA, 10)),
  x1 = rnorm(60),
  x2 = rnorm(60)
)
result <- DAVGMMI(data, R = 50, M = 10)
head(result$Yhat)

}
