% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkPvalues.R
\name{benchmarkP}
\alias{benchmarkP}
\title{General Type I/II benchmarks}
\usage{
benchmarkP(controlValues = 0, getP, nRep = 10, alpha = 0.05, plot = T,
  parallel = F)
}
\arguments{
\item{controlValues}{a vector with a control parameter (e.g. to vary the strength of a problem the test should be specific to)}

\item{getP}{the test to be benchmarked - this should be a function that takes one of the controlValues as an input, and returns a p-value}

\item{nRep}{number of replicates per level of the controlValues}

\item{alpha}{significance level}

\item{plot}{whether to do a plot}

\item{parallel}{whether to use parallel computations. Possible values are F, T (parallel cores set to number of cores in the computer -1), or an integer number for the number of cores that should be used}
}
\description{
This function runs Power / Type I error simulations for an arbitrary test with a control parameter
}
\note{
The benchmark function in DHARMa are intended for development purposes, and for users that want to test / confirm the properties of functions in DHARMa. If you are running an applied data analysis, they are probably of little use.
}
\seealso{
\code{\link{benchmarkUniformity}}
}

