% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{binom.nettest}
\alias{binom.nettest}
\title{Performes a binomial test with FDR correction for network edge occurrence.}
\usage{
binom.nettest(adj, alter = "two.sided", fdr = 0.05)
}
\arguments{
\item{adj}{adjacency matrix, nodes x nodes x subj, or nodes x nodes x runs x subj.}

\item{alter}{type of binomial test, "two.sided" (default), "less", or "greater"}

\item{fdr}{false discovery rate (FDR) control, default is 0.05.}
}
\value{
store list with results.
}
\description{
Performes a binomial test with FDR correction for network edge occurrence.
}
\examples{
# Generate some sample binary 5-node network structures for N=20, then perform
# significance testing.
N=20
x = rmdiag(array(rbinom(n=5*5*N, size=1, prob=0.10), dim=c(5,5,N)))
x[1,2,2:N]=1; x[2,3,seq(1,N,2)]=1 # add some consitent edges
A = apply(x, c(1,2), mean)
l = binom.nettest(x)

}
