% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCol.R
\name{extractCol}
\alias{extractCol}
\title{Extract a named column from a series of df or matrices}
\usage{
extractCol(contrastList, colName, robust = TRUE)
}
\arguments{
\item{contrastList}{A list of data.frames which all have the same colnames and same row counts.
The dataframes in the list should have geneIDs as rownames.}

\item{colName}{The name of the data column to extract into a matrix.}

\item{robust}{Default = TRUE; TRUE forces use of a joins to merge columns
which is more reliable and allows for combination of contrasts from different
projects, but may not return items in the same row order as the source
table. Setting to FALSE invokes a cbind() approach that requires all
data.frames to have the same row count and row order but preserves the
original row order.}
}
\value{
A dataframe containing the extracted columns
}
\description{
Take a named list of dataframes where each dataframe has the same
column names (e.g. a list of topTable dataframes), then extract
the named column from each dataframe and return a matrix.  The name of
each dataframe is used as the column name in the resulting table.
}
\details{
The common use case for this is to provide a list of topTable
data frames and extract one column from each file to create
a matrix of LogRatios or P-values (genes x contrasts)..

This should work as long as the requested column name is present in every
dataframe.  The default robust = TRUE should be used unless it has been
verified that each dataframe in the input list has the same row count and row
order.
}
\examples{
   dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
   TopTableList <- DGEobj::getType(dgeObj, type = "topTable")
   MyPvalues    <- extractCol(TopTableList, colName = "P.Value")
   head(MyPvalues)

}
