% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-sql.R
\name{test_sql}
\alias{test_sql}
\title{Test SQL methods}
\usage{
test_sql(skip = NULL, ctx = get_default_context())
}
\arguments{
\item{skip}{\code{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.}

\item{ctx}{\code{[DBItest_context]}\cr A test context as created by
\code{\link{make_context}}.}
}
\description{
Test SQL methods
}
\details{
This function defines the following tests:
\describe{
\item{\code{quote_string}}{
Can quote strings, and create strings that contain quotes and spaces
}
\item{\code{quote_string_vectorized}}{
Can quote more than one string at once by passing a character vector.

}
\item{\code{quote_identifier}}{
Can quote identifiers that consist of letters only
}
\item{\code{quote_identifier_special}}{
Can quote identifiers with special characters, and create identifiers
that contain quotes and spaces
}
\item{\code{quote_identifier_not_vectorized}}{
Character vectors are treated as a single qualified identifier.
}
\item{\code{write_table}}{
Can write the \code{\link[datasets]{iris}} data as a table to the
database, but won't overwrite by default.
}
\item{\code{read_table}}{
Can read the \code{\link[datasets]{iris}} data from a database table.
}
\item{\code{overwrite_table}}{
Can write the \code{\link[datasets]{iris}} data as a table to the
database, will overwrite if asked.
}
\item{\code{append_table}}{
Can write the \code{\link[datasets]{iris}} data as a table to the
database, will append if asked.
}
\item{\code{append_table}}{
Cannot append to nonexisting table.
}
\item{\code{temporary_table}}{
Can write the \code{\link[datasets]{iris}} data as a temporary table to
the database, the table is not available in a second connection and is
gone after reconnecting.
}
\item{\code{table_visible_in_other_connection}}{
A new table is visible in a second connection.
}
\item{\code{list_tables}}{
Can list the tables in the database, adding and removing tables affects
the list. Can also check existence of a table.
}
\item{\code{list_fields}}{
Can list the fields for a table in the database.
}
\item{\code{roundtrip_keywords}}{
Can create tables with keywords as table and column names.
}
\item{\code{roundtrip_quotes}}{
Can create tables with quotes, commas, and spaces in column names and
data.
}
\item{\code{roundtrip_integer}}{
Can create tables with integer columns.
}
\item{\code{roundtrip_numeric}}{
Can create tables with numeric columns.
}
\item{\code{roundtrip_numeric_special}}{
Can create tables with numeric columns that contain special values such
as \code{Inf} and \code{NaN}.
}
\item{\code{roundtrip_logical}}{
Can create tables with logical columns.
}
\item{\code{roundtrip_logical_int}}{
Can create tables with logical columns, returned as integer.
}
\item{\code{roundtrip_null}}{
Can create tables with NULL values.
}
\item{\code{roundtrip_64_bit}}{
Can create tables with 64-bit columns.
}
\item{\code{roundtrip_character}}{
Can create tables with character columns.
}
\item{\code{roundtrip_factor}}{
Can create tables with factor columns.
}
\item{\code{roundtrip_raw}}{
Can create tables with raw columns.
}
\item{\code{roundtrip_date}}{
Can create tables with date columns.
}
\item{\code{roundtrip_timestamp}}{
Can create tables with timestamp columns.
}
\item{\code{roundtrip_rownames}}{
Can create tables with row names.
}
}
}
\seealso{
Other tests: \code{\link{test_compliance}},
  \code{\link{test_connection}}, \code{\link{test_driver}},
  \code{\link{test_getting_started}},
  \code{\link{test_meta}}, \code{\link{test_result}}
}

