% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_result.R
\name{test_result}
\alias{test_result}
\title{Test the "Result" class}
\usage{
test_result(skip = NULL, ctx = get_default_context())
}
\arguments{
\item{skip}{\code{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.}

\item{ctx}{\code{[DBItest_context]}\cr A test context as created by
\code{\link{make_context}}.}
}
\description{
Test the "Result" class
}
\details{
This function defines the following tests:
\describe{
\item{\code{trivial_query}}{
Can issue trivial query, result object inherits from "DBIResult"
}
\item{\code{clear_result_return}}{
Return value, currently tests that the return value is always
\code{TRUE}, and that an attempt to close a closed result set issues a
warning.
}
\item{\code{stale_result_warning}}{
Leaving a result open when closing a connection gives a warning
}
\item{\code{command_query}}{
Can issue a command query that creates a table, inserts a row, and
deletes it; the result sets for these query always have "completed"
status.
}
\item{\code{invalid_query}}{
Issuing an invalid query throws error (but no warnings, e.g. related to
  pending results, are thrown)
}
\item{\code{fetch_single}}{
single-value queries can be fetched
}
\item{\code{fetch_multi_row_single_column}}{
multi-row single-column queries can be fetched
}
\item{\code{fetch_progressive}}{
multi-row queries can be fetched progressively
}
\item{\code{fetch_more_rows}}{
if more rows than available are fetched, the result is returned in full
  but no warning is issued
}
\item{\code{fetch_premature_close}}{
if less rows than available are fetched, the result is returned in full
  but no warning is issued; also tests the corner case of fetching zero
  rows
}
\item{\code{fetch_no_return_value}}{
side-effect-only queries (without return value) can be fetched
}
\item{\code{fetch_closed}}{
Fetching from a closed result set raises an error
}
\item{\code{cannot_query_disconnected}}{
Querying a disconnected connection throws error.
}
\item{\code{get_query_single}}{
single-value queries can be read with dbGetQuery
}
\item{\code{get_query_multi_row_single_column}}{
multi-row single-column queries can be read with dbGetQuery
}
\item{\code{get_query_empty_single_column}}{
Empty single-column queries can be read with dbGetQuery
}
\item{\code{get_query_single_row_multi_column}}{
single-row multi-column queries can be read with dbGetQuery
}
\item{\code{get_query_multi}}{
multi-row multi-column queries can be read with dbGetQuery
}
\item{\code{get_query_empty_multi_column}}{
Empty multi-column queries can be read with dbGetQuery
}
\item{\code{data_type_connection}}{
SQL Data types exist for all basic R data types, and the engine can
process them.
}
\item{\code{data_type_factor}}{
SQL data type for factor is the same as for character.
}
\item{\code{data_integer}}{
data conversion from SQL to R: integer
}
\item{\code{data_integer_null_below}}{
data conversion from SQL to R: integer with typed NULL values
}
\item{\code{data_integer_null_above}}{
data conversion from SQL to R: integer with typed NULL values
in the first row
}
\item{\code{data_numeric}}{
data conversion from SQL to R: numeric
}
\item{\code{data_numeric_null_below}}{
data conversion from SQL to R: numeric with typed NULL values
}
\item{\code{data_numeric_null_above}}{
data conversion from SQL to R: numeric with typed NULL values
in the first row
}
\item{\code{data_logical}}{
data conversion from SQL to R: logical
}
\item{\code{data_logical_null_below}}{
data conversion from SQL to R: logical with typed NULL values
}
\item{\code{data_logical_null_above}}{
data conversion from SQL to R: logical with typed NULL values
in the first row
}
\item{\code{data_logical_int}}{
data conversion from SQL to R: logical (as integers)
}
\item{\code{data_logical_int_null_below}}{
data conversion from SQL to R: logical (as integers) with typed NULL
values
}
\item{\code{data_logical_int_null_above}}{
data conversion from SQL to R: logical (as integers) with typed NULL
values
in the first row
}
\item{\code{data_null}}{
data conversion from SQL to R: A NULL value is returned as NA
}
\item{\code{data_64_bit}}{
data conversion from SQL to R: 64-bit integers
}
\item{\code{data_64_bit_null_below}}{
data conversion from SQL to R: 64-bit integers with typed NULL values
}
\item{\code{data_64_bit_null_above}}{
data conversion from SQL to R: 64-bit integers with typed NULL values
in the first row
}
\item{\code{data_character}}{
data conversion from SQL to R: character
}
\item{\code{data_character_null_below}}{
data conversion from SQL to R: character with typed NULL values
}
\item{\code{data_character_null_above}}{
data conversion from SQL to R: character with typed NULL values
in the first row
}
\item{\code{data_raw}}{
data conversion from SQL to R: raw
}
\item{\code{data_raw_null_below}}{
data conversion from SQL to R: raw with typed NULL values
}
\item{\code{data_raw_null_above}}{
data conversion from SQL to R: raw with typed NULL values
in the first row
}
\item{\code{data_date}}{
data conversion from SQL to R: date, returned as integer with class
}
\item{\code{data_date_null_below}}{
data conversion from SQL to R: date with typed NULL values
}
\item{\code{data_date_null_above}}{
data conversion from SQL to R: date with typed NULL values
in the first row
}
\item{\code{data_time}}{
data conversion from SQL to R: time
}
\item{\code{data_time_null_below}}{
data conversion from SQL to R: time with typed NULL values
}
\item{\code{data_time_null_above}}{
data conversion from SQL to R: time with typed NULL values
in the first row
}
\item{\code{data_time_parens}}{
data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals)
}
\item{\code{data_time_parens_null_below}}{
data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals) with typed NULL values
}
\item{\code{data_time_parens_null_above}}{
data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals) with typed NULL values
in the first row
}
\item{\code{data_timestamp}}{
data conversion from SQL to R: timestamp
}
\item{\code{data_timestamp_null_below}}{
data conversion from SQL to R: timestamp with typed NULL values
}
\item{\code{data_timestamp_null_above}}{
data conversion from SQL to R: timestamp with typed NULL values
in the first row
}
\item{\code{data_timestamp_utc}}{
data conversion from SQL to R: timestamp with time zone
}
\item{\code{data_timestamp_utc_null_below}}{
data conversion from SQL to R: timestamp with time zone with typed NULL
values
}
\item{\code{data_timestamp_utc_null_above}}{
data conversion from SQL to R: timestamp with time zone with typed NULL
values
in the first row
}
\item{\code{data_timestamp_parens}}{
data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals)
}
\item{\code{data_timestamp_parens_null_below}}{
data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals) with typed NULL values
}
\item{\code{data_timestamp_parens_null_above}}{
data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals) with typed NULL values
in the first row
}
}
}
\seealso{
Other tests: \code{\link{test_compliance}},
  \code{\link{test_connection}}, \code{\link{test_driver}},
  \code{\link{test_getting_started}},
  \code{\link{test_meta}}, \code{\link{test_sql}}
}

