% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{item_analysis}
\alias{item_analysis}
\title{Item Analysis}
\usage{
item_analysis(score_csv_data, m_cutoff = 0.15)
}
\arguments{
\item{score_csv_data}{data This function requires a csv data file.
Its name (e.g., "data_treat_pre.csv") can be passed as an argument.
Make sure to set the folder with the data file(s) as the working directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{difficulty_index}: Calculated difficulty scores
 \item \code{difficulty_index_plot}: Plot of difficulty scores in the
 ascending order
 \item \code{too_difficulty_items}: List of items of which difficulty score
 is less than 0.2
 \item \code{discrimination_index}: Calculated discrimination scores
 \item \code{discrimination_index_plot}: Plot of discrimination scores in the
 ascending order
 \item \code{non_discrimination_items}: List of items of which discrimination
 score is less than 0.2
}
}
\description{
This function automatically reads and cleans the data (e.g., converting
missing values to "0"), and calculates difficulty and discriminant scores.
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
item_analysis(score_csv_data =
         system.file("extdata", "data_treat_pre.csv", package = "DBERlibR"),
         m_cutoff = 0.15)

}
