% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_feature_response.R
\name{plot.model_feature_response_explainer}
\alias{plot.model_feature_response_explainer}
\title{Plots Marginal Model Explanations (Single Variable Responses)}
\usage{
\method{plot}{model_feature_response_explainer}(x, ...,
  use_facets = FALSE)
}
\arguments{
\item{x}{a single variable exlainer produced with the 'single_feature' function}

\item{...}{other explainers that shall be plotted together}

\item{use_facets}{logical. If TRUE then separate models are on different facets}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.variable_response_explainer' plots marginal responses for one or more explainers.
}
\examples{
library("DALEX")

HR_glm_model <- glm(status == "fired" ~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
expl_glm <- model_feature_response(explainer_glm, "hours", "pdp")
head(expl_glm)
plot(expl_glm)

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status~., data = HR, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR)
expl_rf  <- model_feature_response(explainer_rf, feature = "hours",
                       type = "pdp")
head(expl_rf)
plot(expl_rf)

plot(expl_rf, expl_glm)
plot(expl_rf, expl_glm, use_facets = TRUE)
 }

}
