% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_performance.R
\name{plot.model_performance_explainer}
\alias{plot.model_performance_explainer}
\title{Model Performance Plots}
\usage{
\method{plot}{model_performance_explainer}(x, ..., geom = "ecdf",
  lossFunction = function(x) sqrt(mean(x^2)))
}
\arguments{
\item{x}{a model to be explained, preprocessed by the 'explain' function}

\item{...}{other parameters}

\item{geom}{either \code{"ecdf"} or \code{"boxplot"} determines how residuals shall be summarized}

\item{lossFunction}{A function that calculates the total loss for a model based on model residuals. By default it's the root mean square.}
}
\value{
An object of the class 'model_performance_explainer'.
}
\description{
Model Performance Plots
}
\examples{
 \dontrun{
library("breakDown")
library("randomForest")
HR_rf_model <- randomForest(left~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data, y = HR_data$left)
mp_rf <- model_performance(explainer_rf)
plot(mp_rf)

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data, y = HR_data$left, label = "glm",
                    predict_function = function(m,x) predict.glm(m,x,type = "response"))
mp_glm <- model_performance(explainer_glm)
plot(mp_glm)

HR_lm_model <- lm(left~., data = breakDown::HR_data)
explainer_lm <- explain(HR_lm_model, data = HR_data, y = HR_data$left)
mp_lm <- model_performance(explainer_lm)
plot(mp_lm)

plot(mp_rf, mp_glm, mp_lm)
plot(mp_rf, mp_glm, mp_lm, geom = "boxplot")
 }

}
