% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_core_1_4.R
\name{DAISIE_calc_clade_imm_rate}
\alias{DAISIE_calc_clade_imm_rate}
\title{Calculate the clade-wide immigration rate.}
\usage{
DAISIE_calc_clade_imm_rate(
  ps_imm_rate,
  n_island_species,
  n_mainland_species,
  carr_cap
)
}
\arguments{
\item{ps_imm_rate}{per species immigration rate}

\item{n_island_species}{number of species in that clade on the island}

\item{n_mainland_species}{number of species in that clade on the mainland}

\item{carr_cap}{carrying capacity, number of species this clade will
grow to}
}
\value{
the clade's immigration rate, which is at least zero. This
  rate will be zero if there are more species than the carrying capacity
  allows for
}
\description{
Calculate the clade-wide immigration rate.
}
\examples{
  testit::assert(
    DAISIE:::DAISIE_calc_clade_imm_rate(
      ps_imm_rate = 0.1,
      n_island_species = 5,
      n_mainland_species = 2,
      carr_cap = 10
    ) == 0.1
  )
  testit::assert(
    DAISIE:::DAISIE_calc_clade_imm_rate(
      ps_imm_rate = 0.1,
      n_island_species = 5,
      n_mainland_species = 2,
      carr_cap = 1
    ) == 0.0
  )
}
\author{
Richel J.C. Bilderbeek
}
\keyword{internal}
