% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseevents.R
\name{parseevents}
\alias{parseevents}
\title{Modifies the list obtained from a call to statistics.events to a matrix with rows corresponding to fcs files and columns corresponding to the population types}
\usage{
parseevents(results, popsinterest, fcs)
}
\arguments{
\item{results}{- The results of a call to statistics.events function}

\item{popsinterest}{- List of gateSetID numbers for populations of interest with descriptions as names}

\item{fcs}{- List of fcs file IDs of interest with description of FCS files as names}
}
\value{
Returns a matrix of event counts with rows corresponding to fcs files and columns corresponding to populations of interest
}
\description{
Modifies the list obtained from a call to statistics.events to a matrix with rows corresponding to fcs files and columns corresponding to the population types
}
\examples{
\donttest{
library(CytobankAPI)

cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
exptno<-2
popsofinterest1<-c("CD4 T cells","NK cells")
popsinterest<-getpops(popsofinterest1,exptno,cyto_session)
fcs<-getfcsfiles(exptno,cyto_session)
results<-statistics.event_counts(cyto_session, exptno, gate_version = 1, 
compensation_id=1,fcs_files=fcs,populations = popsinterest,output = "default",
timeout = UserSession@long_timeout)
parseevents(results,popsinterest,fcs)}
}
