% Generated by roxygen2 (4.0.2): do not edit by hand
\name{general.carryover}
\alias{general.carryover}
\title{Calculate variances of paramater contrasts}
\usage{
general.carryover(design, v = length(table(design)), model, ppp = 0.5,
  placebos = 1, contrasts)
}
\arguments{
\item{design}{Cross-over design.}

\item{v}{Number of treatments}

\item{model}{Model - one of the following numbers or Strings: 1 = "Standard
additive model", 2 = "Self-adjacency model", 3 = "Proportionality model", 4
= "Placebo model", 5 = "No carry-over into self model", 6 = "Treatment decay
model", 7 = "Full set of interactions", 8 = "Second-order carry-over
effects"}

\item{ppp}{The proportionality parameter for the proportionality model.}

\item{placebos}{The number of placebo treatments in the placebo model.}

\item{contrasts}{Optionally a contrast matrix or a list of contrast matrix.
If missing pairwise differences for treatment and carry-over parameters
are calculated.}
}
\value{
A list with the variances of the pairwise differences or specified contrasts.
If contrasts are not estimable, NA is returned for variances.
}
\description{
Calculate variances of paramater contrasts
}
\details{
See the vignette of this package for further details.
}
\examples{
general.carryover(getDesign("fletcher1"), model=1)
general.carryover(getDesign("fletcher1"), model=2)
general.carryover(getDesign("fletcher1"), model=3)
general.carryover(getDesign("switchback4t"), model=7)
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\references{
Jones, B., & Kenward, M. G. (2003). Design and analysis of
cross-over trials (Vol. 98). Chapman & Hall.
}
\keyword{misc}

