% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dWeibullCount_mat}
\alias{dWeibullCount_mat}
\alias{dWeibullCount_acc}
\title{Univariate Weibull Count Probability}
\usage{
dWeibullCount_mat(x, shape, scale, time = 1, logFlag = FALSE,
  jmax = 50L)

dWeibullCount_acc(x, shape, scale, time = 1, logFlag = FALSE,
  jmax = 50L, nmax = 300L, eps = 1e-10, printa = FALSE)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{shape}{numeric (length 1), shape parameter of the Weibull count.}

\item{scale}{numeric (length 1), scale parameter of the Weibull count.}

\item{time}{double, length of the observation window (defaults to 1).}

\item{logFlag}{logical, if TRUE, the log of the probability will be returned.}

\item{jmax}{integer, number of terms used to approximate the (infinite)
series.}

\item{nmax}{integer, an upper bound on the number of terms to be summed in
the Euler-van Wijngaarden sum; default is 300 terms.}

\item{eps}{numeric, the desired accuracy to declare convergence.}

\item{printa}{logical, if \code{TRUE} print information about convergence.}
}
\value{
a vector of probabilities for each component of the count vector
    \code{x}.
}
\description{
Univariate Weibull count probability computed using matrix techniques.
}
\details{
\code{dWeibullCount_mat} implements formulae (11) of \emph{McShane(2008)} to
compute the required probabilities.  For speed, the computations are
implemented in C++ and of matrix computations are used whenever possible.
This implementation is not efficient as it recomputes the alpha
matrix each time, which may slow down computation (among other things).

\code{dWeibullCount_acc} achieves a vast (several orders of magnitude) speed
improvement over \code{pWeibullCountOrig}. We achieve this by using Euler-van
Wijngaarden techniques for accelerating the convergence of alternating series
and tabulation of the alpha terms available in a pre-computed matrix (shipped
with the package).

When computation time is an issue, we recommend the use of
\code{dWeibullCount_fast}. However, \code{pWeibullCountOrig} may be more
accurate, especially when \code{jmax} is large.
}
\keyword{internal}
