% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renewal_methods.R
\name{renewal_methods}
\alias{coef.renewal}
\alias{confint.renewal}
\alias{df.residual.renewal}
\alias{fitted.renewal}
\alias{logLik.renewal}
\alias{model.matrix.renewal}
\alias{nobs.renewal}
\alias{print.renewal}
\alias{print.summary.renewal}
\alias{renewal_methods}
\alias{residuals.renewal}
\alias{summary.renewal}
\alias{vcov.renewal}
\title{Methods for renewal objects}
\usage{
\method{coef}{renewal}(object, ...)

\method{vcov}{renewal}(object, ...)

\method{residuals}{renewal}(object, type = c("pearson", "response"), ...)

\method{fitted}{renewal}(object, ...)

\method{confint}{renewal}(object, parm, level = 0.95, type = c("asymptotic",
  "boot"), bootType = c("norm", "bca", "basic", "perc", "all"), ...)

\method{summary}{renewal}(object, ...)

\method{print}{renewal}(x, digits = max(3, getOption("digits") - 3), ...)

\method{print}{summary.renewal}(x, digits = max(3, getOption("digits") - 3),
  ...)

\method{model.matrix}{renewal}(object, ...)

\method{logLik}{renewal}(object, ...)

\method{nobs}{renewal}(object, ...)

\method{df.residual}{renewal}(object, ...)
}
\arguments{
\item{object, ..., type, parm, level, bootType, x, digits}{TODO}
}
\description{
Methods for renewal objects.
}
\examples{
fn <- system.file("extdata", "McShane_Wei_results_boot.RDS", package = "Countr")
object <- readRDS(fn)
class(object) # "renewal"

coef(object)
vcov(object)

## Pearson residuals: rescaled by sd
head(residuals(object, "pearson"))
## response residuals: not rescaled
head(residuals(object, "response"))

head(fitted(object))

## loglik, nobs, AIC, BIC
c(loglik = as.numeric(logLik(object)), nobs = nobs(object),
  AIC = AIC(object), BIC = BIC(object))

asym <- se.coef(object, , "asymptotic")
boot <- se.coef(object, , "boot")
cbind(asym, boot)
## CI for coefficients
asym <- confint(object, type = "asymptotic")
## Commenting out for now, see the nite in the code of confint.renewal():
## boot <- confint(object, type = "boot", bootType = "norm")
## list(asym = asym, boot = boot)
summary(object)
print(object)
## see renewal_methods
}

