% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dmodifiedCount_user}
\alias{dmodifiedCount_user}
\title{Compute count probabilities based on modified renewal process (user)}
\usage{
dmodifiedCount_user(x, distPars, survR, distPars0, survR0, extrapolPars,
  nsteps = 100L, time = 1, extrap = TRUE, cdfout = FALSE,
  logFlag = FALSE)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars}{\code{Rcpp::List} with distribution specific slots
for the first arrival and the rest of the process respectively.}

\item{distPars0}{\code{Rcpp::List} with distribution specific slots
for the first arrival and the rest of the process respectively.}

\item{survR0, survR}{Rcpp::Function user passed survival function; should have the
signature \code{function(t, distPars)} where \code{t} is a real number (>0)
where the survival function is evaluated and \code{distPars} is a list of
distribution parameters. It should return a double value (first arrival and
following arrivals respectively).}

\item{extrapolPars}{list of same length as x where each slot is a vector
of length 2 (the extrapolation values to be used) corresponding to
\code{x[i]}.}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{cdfout}{TODO}

\item{logFlag}{logical if \code{TRUE} the log-probability will be returned.}
}
\value{
vector of probabilities P(x(i)) for i = 1, ..., n where n is
\code{length} of \code{x}.
}
\description{
Compute count probabilities based on modified renewal process using
dePril algorithm.
}
\details{
The process is assumed to have a different distribution for the first
arrival. The renewal assumption is conserved.
}

