% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dmodifiedCount_bi}
\alias{dmodifiedCount_bi}
\title{Compute count probabilities based on modified renewal process (bi)}
\usage{
dmodifiedCount_bi(x, distPars, dist, distPars0, dist0, nsteps = 100L,
  time = 1, extrap = TRUE, cdfout = FALSE, logFlag = FALSE)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars0, distPars}{\code{Rcpp::List} with distribution specific slots
for the first arrival and the rest of the process respectively.}

\item{dist0, dist}{character name of the first and following survival
distributions.}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{cdfout}{TODO}

\item{logFlag}{logical if \code{TRUE} the log-probability will be returned.}
}
\value{
vector of probabilities P(x(i)) for i = 1, ..., n where n is
\code{length} of \code{x}.
}
\description{
Compute count probabilities based on modified renewal process using
dePril algorithm.
}
\details{
The process is assumed to have a different distribution for the first
arrival. The renewal assumption is conserved.
}

