% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWeibull.R
\name{dWeibullCount}
\alias{dWeibullCount}
\alias{dWeibullCount_loglik}
\alias{evWeibullCount}
\title{wrapper to the weibull count probability}
\usage{
dWeibullCount(x, shape, scale, method = c("series_acc", "series_mat",
  "conv_direct", "conv_naive", "conv_dePril"), time = 1, log = FALSE,
  conv_steps = 100, conv_extrap = TRUE, series_terms = 50,
  series_acc_niter = 300, series_acc_eps = 1e-10)

dWeibullCount_loglik(x, shape, scale, method = c("series_acc", "series_mat",
  "conv_direct", "conv_naive", "conv_dePril"), time = 1, na.rm = TRUE,
  conv_steps = 100, conv_extrap = TRUE, series_terms = 50,
  series_acc_niter = 300, series_acc_eps = 1e-10, weights = NULL)

evWeibullCount(xmax, shape, scale, method = c("series_acc", "series_mat",
  "conv_direct", "conv_naive", "conv_dePril"), time = 1, conv_steps = 100,
  conv_extrap = TRUE, series_terms = 50, series_acc_niter = 300,
  series_acc_eps = 1e-10)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{shape}{numeric (length 1), shape parameter of the Weibull count.}

\item{scale}{numeric (length 1), scale parameter of the Weibull count.}

\item{method}{character one of the available methods. See details.}

\item{time}{double, length of the observation window (defaults to 1).}

\item{log}{logical, if TRUE, the log of the probability will be returned.}

\item{conv_steps}{numeric number of steps used for the extrapolation.}

\item{conv_extrap}{logical should Richardson extrappolation be applied ?}

\item{series_terms}{numeric number of terms in the series expansion.}

\item{series_acc_niter}{numeric number of iteration in the
Euler-van Wijngaarden algorithm.}

\item{series_acc_eps}{numeric tolerance of convergence in the
Euler-van Wijngaarden algorithm.}

\item{na.rm}{logical if TRUE, the \code{NA} (produced by taking the log of
very small probabilities) will be replaced by the smallest allowed probaility;
default = \code{TRUE}}

\item{weights}{numeric vector of weights to apply. If \code{NULL}, one will
be applied.}

\item{xmax}{unsigned integer maximum count to be used.}
}
\value{
vector of probabilities \eqn{P(x(i)), i = 1, \dots n} where
\code{n = length(x)}.

double log-likelihood of the count process

double log-likelihood of the count process
}
\description{
wrapper to the univariate weibull count probability

wrapper to the univariate weibull log-likelihood

Expcted value and varinace of the weibull count process
}
\details{
User could choose between one of the following methods:
\describe{
\item{series_mat}{series expansion using matrix techniques.}
\item{series_acc}{Euler-van Wijngaarden accelerated series expansion}
\item{conv_direct}{direct convolution method of section 2.}
\item{conv_naive}{naive convolurion described in section 3.1}
\item{conv_dePril}{dePril convolution described in section 3.2}
}
The valiue of the inputs can be left to their default value if user
is not aware of the algorithm details.
}

