% Generated by roxygen2 (4.0.2): do not edit by hand
\name{multi.corr}
\alias{multi.corr}
\title{Extract correlation coefficients from joint probability arrays}
\usage{
multi.corr(jp, type = attr(jp, "type"))
}
\arguments{
\item{jp}{the output of \code{\link{jointprobs}} - a list of joint probability arrays by treatment}

\item{type}{one of c("averaged","cluster","mc") - the type of joint probability. By default,
the \code{type} attribute of \code{jp} is used.}
}
\value{
a list of estimated correlation matrices by treatment group. If cluster-size specific
estimates were requested (\code{(type="cluster")}), then each list elements are a list of
these matrices for each cluster size.
}
\description{
Calculates the within- and between-outcome correlation coefficients for exchangeable correlated
multinomial data based on joint probability estimates calculated by the \code{\link{jointprobs}}
function. These determine the variance inflation due the cluster structure.
}
\details{
If \eqn{R_i} and \eqn{R_j} is the number of events of type \eqn{i} and \eqn{j}, respectively, in a cluster of
size \eqn{n}, then
\deqn{Var(R_i)= n p_i (1-p_i)(1 + (n-1)\phi_{ii})}
\deqn{Cov(R_i,R_j)= -n p_i p_j (1 + (n-1)\phi_{ij})}
where \eqn{p_i} and \eqn{p_j} are the marginal event probabilities and \eqn{\phi_{ij}} are the correlation
coefficients computed by \code{multi.corr}.
}
\examples{
data(dehp)
tau <- jointprobs(dehp, type="averaged")
multi.corr(tau)
}
\seealso{
\code{\link{jointprobs}} for calculating the joint probability arrays
}

