% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_product_metadata.r
\name{copernicus_product_metadata}
\alias{copernicus_product_metadata}
\title{Obtain meta data for a specific Copernicus marine product}
\usage{
copernicus_product_metadata(product)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}
}
\value{
Returns a named \code{list} with info about the requested \code{product}. Returns \code{NULL}
when contacting Copernicus fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated. Use \code{\link[=cms_product_metadata]{cms_product_metadata()}} instead.
}
\details{
Collect meta information, such as vocabularies used,
for specific Copernicus marine products
}
\examples{
\dontrun{
copernicus_product_metadata("GLOBAL_ANALYSISFORECAST_PHY_001_024")
}
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_details}()},
\code{\link{cms_product_metadata}()},
\code{\link{cms_product_services}()},
\code{\link{cms_products_list}()},
\code{\link{copernicus_cite_product}()},
\code{\link{copernicus_product_details}()},
\code{\link{copernicus_products_list}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
