% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_iucn.R
\name{cc_iucn}
\alias{cc_iucn}
\title{Identify Records Outside Natural Ranges}
\usage{
cc_iucn(
  x,
  range,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  species = "species",
  buffer = 0,
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species names.}

\item{range}{a SpatVector of natural ranges for species in x. 
Must contain a column named as indicated by \code{species}. See details.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimalLongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimalLatitude}.}

\item{species}{a character string. The column with the species name. 
Default = \dQuote{species}.}

\item{buffer}{numerical. The buffer around each species' range,
from where records should be flagged as problematic, in meters. Default = 0.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records outside of the provided natural range polygon, on a per species basis. 
Expects one entry per species. See the example or 
\url{https://www.iucnredlist.org/resources/spatial-data-download} for 
the required polygon structure.
}
\details{
Download natural range maps in suitable format for amphibians, birds,
mammals and reptiles
from \url{https://www.iucnredlist.org/resources/spatial-data-download}.
Note: the buffer radius is in degrees, thus will differ slightly between
different latitudes.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{
library(terra)

x <- data.frame(species = c("A", "B"),
decimalLongitude = runif(100, -170, 170),
decimalLatitude = runif(100, -80,80))

range_species_A <- cbind(c(-45,-45,-60,-60,-45), c(-10,-25,-25,-10,-10))
rangeA <- terra::vect(range_species_A, "polygons")
range_species_B <- cbind(c(15,15,32,32,15), c(10,-10,-10,10,10))
rangeB <- terra::vect(range_species_B, "polygons")
range <- terra::vect(list(rangeA, rangeB))
range$binomial <- c("A", "B")

cc_iucn(x = x, range = range, buffer = 0)

}
\seealso{
Other Coordinates: 
\code{\link{cc_aohi}()},
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_urb}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
