% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWquickcons.R
\name{iwquickcons}
\alias{iwquickcons}
\title{The item-weighted Quick algorithm to find up to 4 solutions to the consensus ranking problem}
\usage{
iwquickcons(X, w, Wk = NULL, full = FALSE, PS = FALSE)
}
\arguments{
\item{X}{A N by M data matrix in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once in the sample. In this case the argument Wk must be used}

\item{w}{A M-dimensional row vector (individually weighted items), or a M by M matrix (item similarities)}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{full}{Default full=FALSE. If full=TRUE, the searching is limited to the space of full rankings.}

\item{PS}{Default PS=FALSE. If PS=TRUE the number of evaluated branches is diplayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged item-weighted TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
The item-weighted Quick algorithm finds up to 4 solutions. Solutions reached are most of the time optimal solutions.
}
\details{
The item-weigthed Quick algorithm finds up the consensus (median) ranking according to the Kemeny's axiomatic approach. The median ranking(s) can be restricted to be necessarily a full ranking, namely without ties.
}
\examples{
#Individually weighted items
data("German")
w=c(10,5,5,10)
iwquickcons(X= German,w= w)

#Item similirity weights
data(sports)
dim(sports)
P=matrix(NA,nrow=7,ncol=7)
P[1,]=c(0,5,5,10,10,10,10)
P[2,]=c(5,0,5,10,10,10,10)
P[3,]=c(5,5,0,10,10,10,10)
P[4,]=c(10,10,10,0,5,5,5)
P[5,]=c(10,10,10,5,0,5,5)
P[6,]=c(10,10,10,5,5,0,5)
P[7,]=c(10,10,10,5,5,5,0)
iwquickcons(X= sports, w= P)

}
\references{
Amodio, S., D'Ambrosio, A. and Siciliano, R. (2016). Accurate algorithms for identifying the median ranking when dealing with weak and partial rankings under the Kemeny axiomatic approach. European Journal of Operational Research, 249(2), 667-676. \cr
Albano, A. and Plaia, A. (2021).  Element weighted Kemeny distance for  ranking data. Electronic  Journal  of  Applied Statistical Analysis, doi: 10.1285/i20705948v14n1p117
}
\seealso{
\code{\link{consrank}}
}
\author{
Alessandro Albano \email{alessandro.albano@unipa.it} \cr
Antonella Plaia \email{antonella.plaia@unipa.it}
}
\keyword{Item-weighted}
\keyword{Quick}
\keyword{algorithm}
