% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank2order.R
\name{rank2order}
\alias{rank2order}
\title{Given a rank, it is transformed to a ordering}
\usage{
rank2order(X, items = NULL, TO = "{", TC = "}", itemtype = "L")
}
\arguments{
\item{X}{A ordering or a matrix containing orderings}

\item{items}{items to be placed into the ordering matrix. Default are the}

\item{TO}{symbol indicating the start of a set of items ranked in a tie}

\item{TC}{symbol indicating the end of a set of items ranked in a tie}

\item{itemtype}{to be used only if items=NULL. The default value is "L", namely}
}
\value{
a ordering or a matrix of orderings:
\tabular{lll}{
out \tab  \tab ranking or matrix of rankings}
}
\description{
From ranking to ordering. IMPORTANT: check which symbol denotes tied rankings in the X matrix
}
\examples{
data(APAred)
ord<-rank2order(APAred)

}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
