% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiFramer.R
\name{multi_class_cm}
\alias{multi_class_cm}
\title{Multiple Confusion Matrix data frame}
\usage{
multi_class_cm(train_labels, truth_labels)
}
\arguments{
\item{train_labels}{the classification labels from the training set}

\item{truth_labels}{the testing set ground truth labels for comparison}
}
\value{
A list containing the outputs highlighted hereunder:
\itemize{
\item{\strong{"confusion_matrix"}}{ a confusion matrix list item with all the associated confusion matrix statistics}
\item{\strong{"record_level_cm"}}{ a row by row data.frame version of the above output, to allow for storage in databases and row by row for tracking ML model performance}
\item{\strong{"cm_tbl"}}{ a confusion matrix raw table of the values in the matrix}
\item{\strong{"last_run"}}{datetime object storing when the function was run}
}
}
\description{
a confusion matrix object for multi classification machine learning problems.
}
\examples{
# Get the IRIS data as this is a famous multi-classification problem
library(caret)
library(ConfusionTableR)
library(randomForest)
df <- iris
df <- na.omit(df)
table(iris$Species)
# Create a training / test split
train_split_idx <- caret::createDataPartition(df$Species, p = 0.75, list = FALSE)
# Here we define a split index and we are now going to use a multiclass ML model to fit the data
train <- df[train_split_idx, ]
test <- df[-train_split_idx, ]
# Fit a random forest model on the data
rf_model <- caret::train(Species ~ .,data = df,method = "rf", metric = "Accuracy")
# Predict the values on the test hold out set
rf_class <- predict(rf_model, newdata = test, type = "raw")
predictions <- cbind(data.frame(train_preds=rf_class, test$Species))
# Use ConfusionTableR to create a row level output
cm <- ConfusionTableR::multi_class_cm(predictions$train_preds, predictions$test.Species)
# Create the row level output
cm_rl <- cm$record_level_cm
print(cm_rl)
#Expose the original confusion matrix list
cm_orig <- cm$confusion_matrix
print(cm_orig)
}
