% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummycoder.R
\name{dummy_encoder}
\alias{dummy_encoder}
\title{Dummy Encoder function to encode multiple columns at once}
\usage{
dummy_encoder(df, columns, map_fn = furrr::future_map, remove_original = TRUE)
}
\arguments{
\item{df}{- data.frame object to pass to the function}

\item{columns}{- vector of columns to be encoded for dummy encoding}

\item{map_fn}{- choice of mapping function purrr:map or furr::future_map accepted}

\item{remove_original}{- remove the variables that the dummy encodings are based off}
}
\value{
A tibble containing the dummy encodings
}
\description{
This function has been designed to encode multiple columns at once and allows
the user to specify whether to drop the reference columns or retain them in the data
}
\examples{
\dontrun{
#Use the NHSR stranded dataset
df <- NHSRdatasets::stranded_data
#Create a function to select categorical variables
sep_categorical <- function(df){
 cats <- df \%>\%
   dplyr::select_if(is.character)
 return(cats)
}
cats <- sep_categorical(df) \%>\%
 dplyr::select(-c(admit_date))
#Dummy encoding
columns_vector <- c(names(cats))
dummy_encodings <- dummy_encoder(cats, columns_vector)
glimpse(dummy_encodings)
}
}
