% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IUCNeval.functionv11.R
\name{AOO.computing}
\alias{AOO.computing}
\title{Area of occupancy}
\usage{
AOO.computing(
  XY,
  Cell_size_AOO = 2,
  nbe.rep.rast.AOO = 0,
  parallel = FALSE,
  NbeCores = 2,
  show_progress = TRUE,
  export_shp = FALSE
)
}
\arguments{
\item{XY}{\code{"dataframe"} see Details}

\item{Cell_size_AOO}{numeric, value indicating the grid size in kilometers used for estimating Area of Occupancy.  By default, equal to 2}

\item{nbe.rep.rast.AOO}{numeric , indicate the number of raster with random starting position for estimating the AOO. By default, it is 0 but some minimal translation of the raster are still done}

\item{parallel}{logical, whether running in parallel. By default, it is FALSE}

\item{NbeCores}{string integer, register the number of cores for parallel execution. By default, it is 2}

\item{show_progress}{logical, whether a bar showing progress in computation should be shown. By default, it is TRUE}

\item{export_shp}{logical, whether a shapefile of occupied cells should be exported. By default, it is FALSE}
}
\value{
If \code{export_shp} if FALSE a vector of AOO estimates for each taxa
If \code{export_shp} if TRUE a list with two elements
\enumerate{
  \item a vector of AOO estimates for each taxa
  \item a list of SpatialPolygonsDataFrame for each taxa
}
}
\description{
Compute areas of occupancy (AOO) for multiple taxa in square kilometers
}
\details{
\strong{Input} as a \code{dataframe} should have the following structure:

\strong{It is mandatory to respect field positions, but field names do not matter}

\tabular{ccc}{
  [,1] \tab ddlat \tab numeric, latitude (in decimal degrees)\cr
  [,2] \tab ddlon \tab numeric, longitude (in decimal degrees)\cr
  [,3] \tab tax \tab character or factor, taxa names\cr
}

The argument of \code{nbe.rep.rast.AOO} ideally should be higher than 20 for increasing 
the chance to get the minimal number of occupied cell. Increasing \code{nbe.rep.rast.AOO} however also increase the computing time. 
So this is a trade-off that depend on the importance to get the minimal AOO and the sie of the dataset.
}
\examples{
data(dataset.ex)
\dontrun{
AOO <- AOO.computing(dataset.ex)
}

# This would estimate AOO for all taxa by overlaying randomly a 
# grid 100 times. For each taxa, the minimum value is kept
\dontrun{
AOO <- AOO.computing(dataset.ex, nbe.rep.rast.AO = 100)
}

}
\references{
Gaston & Fuller 2009 The sizes of species'geographic ranges, Journal of Applied Ecology, 49 1-9
}
\author{
Gilles Dauby, \email{gildauby@gmail.com}
}
