% Generated by roxygen2 (4.0.1): do not edit by hand
\name{glm.comp}
\alias{glm.comp}
\title{Conway-Maxwell Poisson GLM Fitting Function}
\usage{
glm.comp(lamFormula, nuFormula = NULL, data, lamStart = NULL,
  nuStart = NULL, sumTo = 100L, method = "BFGS", ...)
}
\arguments{
\item{lamFormula}{an object of class \code{\link{formula}} which determines the form of
regression for the model parameter \eqn{\lambda}. An offset can also be added in the formula.}

\item{nuFormula}{an object of class \code{\link{formula}} which determines the form of
regression for the model parameter \eqn{\nu}. The default value is \code{NULL} meaning the formula is
intercept only. An offset can also be added in the formula.}

\item{data}{an optional \code{\link{data.frame}} containing the variables in the model. If not found in data,
the variables are taken from \code{environment(lamFormula)}.}

\item{lamStart}{optional vector of starting values for the coefficients of the \eqn{\lambda} regression.}

\item{nuStart}{optional vector of starting values for the coefficients of the \eqn{\nu} regression.}

\item{sumTo}{an integer for the summation term in the density (default 100).}

\item{method}{optimisation method passed to \code{\link{optim}} (default "BFGS").}

\item{...}{further arguments to be passed to \code{\link{optim}}.}
}
\value{
An object of class 'Comp' which is a list with all the components needed for the relevant S3 class
methods.
}
\description{
A function in similar format to \code{glm} which provides a linear
form regressing on the parameters lambda and mu.
}
\details{
A log link is used for regression of the model parameters \eqn{\lambda} and \eqn{\nu}, that is:
\deqn{\log(\lambda) = \beta X}{log(\lambda) = \beta X}
\deqn{\log(\nu) = \zeta Y}{log(\nu) = \zeta Y}
where: \eqn{\beta} is the vector of coefficients for the parameter \eqn{\lambda},
\eqn{\zeta} is the vector of coefficients for the parameter \eqn{\nu},
\eqn{X} is the model matrix for the parameter \eqn{\lambda}, and
\eqn{Y} is the model matrix for the parameter \eqn{\nu}.

The parameter vectors are calculated via maximum likelihood using the general optimisation function
\code{\link{optim}}. A Poisson model will be fit using \code{\link{glm.fit}} and (unless starting values
are supplied) the coefficients will be used as starting values for the parameter vector \eqn{\beta}.

Several S3 functions have been implemented for model analysis \code{\link{print}}, \code{\link{coef}},
\code{\link{extractAIC}}, \code{\link{logLik}}, \code{\link{predict}}, and \code{\link{summary}},
}
\examples{
set.seed(1)
n <- 5000
x1 <- rnorm(n, -1.0, 0.5)
x2 <- rnorm(n, 1.0, 0.7)
x3 <- rnorm(n, 2.0, 0.4)
y <- rpois(n, exp(-0.5 + 0.3 * x1 + 0.8 * x2 + 0.2 * x3))
data <- data.frame(y, x1, x2, x3)
model <- glm.comp(y ~ ., data = data)
print(model)
summary(model)
coef(model)
head(predict(model))
AIC(model)
}
\author{
Jeffrey Pollock <jeffpollock9@gmail.com>
}
\references{
A Flexible Regression Model for Count Data, by Sellers & Shmueli,
\url{http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1127359}
}

