% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simula_tte.R
\name{simula_tte}
\alias{simula_tte}
\title{Simulation of composite time-to-event endpoints}
\usage{
simula_tte(
  p0_e1,
  p0_e2,
  HR_e1,
  HR_e2,
  beta_e1 = 1,
  beta_e2 = 1,
  case,
  copula = "Frank",
  rho = 0.3,
  rho_type = "Spearman",
  followup_time = 1,
  sample_size
)
}
\arguments{
\item{p0_e1}{numeric parameter between 0 and 1, expected proportion of observed events for the endpoint E1}

\item{p0_e2}{numeric parameter between 0 and 1, expected proportion of observed events for the endpoint E2}

\item{HR_e1}{numeric parameter between 0 and 1, expected cause specific hazard Ratio the endpoint E1}

\item{HR_e2}{numeric parameter between 0 and 1, expected cause specific hazard Ratio the endpoint E2}

\item{beta_e1}{numeric positive parameter, shape parameter (\eqn{\beta_1}) for a Weibull distribution for the endpoint E1 in the control group. See details for more info.}

\item{beta_e2}{numeric positive parameter, shape parameter (\eqn{\beta_2}) for a Weibull distribution for the endpoint E2 in the control group. See details for more info.}

\item{case}{integer parameter in {1,2,3,4}
1: none of the endpoints is death
2: endpoint 2 is death
3: endpoint 1 is death
4: both endpoints are death by different causes}

\item{copula}{character indicating the copula to be used: "Frank" (default), "Gumbel" or "Clayton". See details for more info.}

\item{rho}{numeric parameter between -1 and 1, Spearman's correlation coefficient o Kendall Tau between the marginal distribution of the times to the two events E1 and E2. See details for more info.}

\item{rho_type}{character indicating the type of correlation to be used: "Spearman" (default) or "Tau". See details for more info.}

\item{followup_time}{numeric parameter indicating the maximum follow up time (in any unit). Default is 1.}

\item{sample_size}{sample size for each arm (treated and control)}
}
\value{
A data.frame with 7 colums: 

\describe{
    \item{\code{time_e1}}{time to event for endpoint 1}
    \item{\code{status_e1}}{The status indicator of endpoint 1, 0=censored, 1=event}
    \item{\code{time_e2}}{time to event for endpoint 2}
    \item{\code{status_e2}}{The status indicator of endpoint 2, 0=censored, 1=event}
    \item{\code{time_ce}}{time to event for composite endpoint}
    \item{\code{status_ce}}{The status indicator of the composite endpoint, 0=censored, 1=event}
    \item{\code{treated}}{0 if control arm and 1, otherwise}
}
}
\description{
This function simulates time-to-event components and their pertinent composite 
endpoint via copulas.
}
\details{
If \code{sample_size} is not an integer, it is rounded to the nearest integer.
}
