% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Convert_Model_Eq}
\alias{Convert_Model_Eq}
\title{Converts a string equation to regression model inputs}
\usage{
Convert_Model_Eq(Model_Eq, df)
}
\arguments{
\item{Model_Eq}{String representation of a survival model. Left hand side details the model (cox, poisson, cox_strata, poisson_strata), time columns, event, and strata when used. The right hand side details the subterm effects. The 'Unified Equation Representation' vignette provides more details.}

\item{df}{a data.table containing the columns of interest}
}
\value{
returns a list of regression inputs
}
\description{
\code{Convert_Model_Eq} Converts a string expression of a risk model into the vectors used by different Colossus regression functions
}
\examples{
library(data.table)
a <- c(0, 1, 2, 3, 4, 5, 6)
b <- c(1, 2, 3, 4, 5, 6, 7)
c <- c(0, 1, 0, 0, 0, 1, 0)
d <- c(1, 2, 3, 4, 5, 6, 7)
e <- c(2, 3, 4, 5, 6, 7, 8)
table <- data.table::data.table(
  "a" = a, "b" = b, "c" = c,
  "d" = d, "e" = e
)
Model_Eq <- "cox(a,b, c) ~ loglinear(d, factor(e), 0) + multiplicative()"
e <- Convert_Model_Eq(Model_Eq, table)

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Event_Count_Gen}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
