% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codesInUse.R
\name{subsetToCodesInUse}
\alias{subsetToCodesInUse}
\title{Filter a codelist to keep only the codes being used in patient records}
\usage{
subsetToCodesInUse(
  x,
  cdm,
  minimumCount = 0L,
  table = c("condition_occurrence", "device_exposure", "drug_exposure", "measurement",
    "observation", "procedure_occurrence", "visit_occurrence")
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference via CDMConnector.}

\item{minimumCount}{Any codes with a frequency under this will be removed.}

\item{table}{cdm table of interest.}
}
\value{
The filtered codelist with only the codes used in the database
}
\description{
Filter a codelist to keep only the codes being used in patient records
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
                           keywords = "arthritis",
                           domains = "Condition",
                           includeDescendants = FALSE)
x <- subsetToCodesInUse(list("cs1" = codes$concept_id,
                               "cs2" = 999),
                                cdm = cdm)

x
CDMConnector::cdmDisconnect(cdm)
}
}
