% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{availableICD10}
\alias{availableICD10}
\title{Get the names of all International Classification of Diseases (ICD) 10 codes}
\usage{
availableICD10(cdm, level = c("ICD10 Chapter", "ICD10 SubChapter"))
}
\arguments{
\item{cdm}{A cdm reference via CDMConnector.}

\item{level}{Can be either "ICD10 Chapter", "ICD10 SubChapter",
"ICD10 Hierarchy", or "ICD10 Code".}
}
\value{
A vector containing the names of all ICD-10 codes for the chosen
level(s) found in the concept table of cdm.
}
\description{
Get the names of all International Classification of Diseases (ICD) 10 codes
}
\examples{
\donttest{
cdm <- mockVocabRef()
availableICD10(cdm)
}
}
